#version 330

uniform sampler2D rtTex;

in vec4 uv;

out vec4 oColor;

const float Threshold = 0.625;
	
void main()
{
	vec4 color = textureLod(rtTex, uv.xy, 0);
	float luminosity = dot(color.rgb, vec3(0.299, 0.587, 0.114));
	
	float intensity = clamp(luminosity - Threshold, 0.0, 1.0) * (1.0 / Threshold);
	intensity = 3 * pow(intensity, 2) - 2 * pow(intensity, 3);
	
	oColor = vec4(color.rgb * (intensity * 0.25 + color.a), 1.0);
}
